<?php
// Basic PHP Test
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>PHP Basic Test</h1>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>Current Time: " . date('Y-m-d H:i:s') . "</p>";

echo "<h2>Step 1: Testing Bootstrap</h2>";
try {
    $container = require __DIR__ . '/../bootstrap.php';
    echo "<p style='color:green'>✓ Bootstrap loaded successfully</p>";
    
    echo "<h2>Step 2: Testing Config</h2>";
    $config = $container['config'];
    echo "<p style='color:green'>✓ Config object created</p>";
    echo "<p>DB_HOST: " . $config->get('DB_HOST') . "</p>";
    echo "<p>DB_NAME: " . $config->get('DB_NAME') . "</p>";
    echo "<p>DB_USER: " . $config->get('DB_USER') . "</p>";
    
    echo "<h2>Step 3: Testing Database Connection</h2>";
    $database = $container['database'];
    echo "<p style='color:green'>✓ Database object created</p>";
    
    $pdo = $database->connection();
    echo "<p style='color:green'>✓ Database connection successful!</p>";
    
    $stmt = $pdo->query('SELECT DATABASE() as db');
    $result = $stmt->fetch();
    echo "<p>Connected to: " . $result['db'] . "</p>";
    
    echo "<h2>Step 4: Testing Installer</h2>";
    require_once __DIR__ . '/../src/Installer.php';
    $installer = new \Parking\Installer(dirname(__DIR__));
    $isInstalled = $installer->isInstalled($database);
    echo "<p>Installation Status: " . ($isInstalled ? 'INSTALLED ✓' : 'NOT INSTALLED ✗') . "</p>";
    
    echo "<hr>";
    echo "<h2 style='color:green'>All Tests Passed!</h2>";
    echo "<p><a href='index.php'>Go to Home Page</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color:red'><strong>ERROR:</strong> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}
