<?php
/**
 * Current System Status Report
 * 
 * هذا الملف يظهر الوضعية الحالية للنظام
 */

echo "<!DOCTYPE html>
<html lang='ar' dir='rtl'>
<head>
    <meta charset='UTF-8'>
    <title>حالة النظام الحالية</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Tahoma, Arial; background: #f5f5f5; padding: 20px; direction: rtl; }
        .container { max-width: 900px; margin: 0 auto; background: white; border-radius: 8px; padding:30px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; margin-bottom: 10px; }
        .status-badge { display: inline-block; padding: 5px 15px; border-radius: 20px; font-weight: bold; margin-bottom: 20px; }
        .status-badge.success { background: #d4edda; color: #155724; }
        .status-badge.warning { background: #fff3cd; color: #856404; }
        .section { margin-top: 30px; padding-top: 20px; border-top: 1px solid #eee; }
        .section h2 { color: #667eea; margin-bottom: 15px; }
        .check { display: flex; align-items: center; padding: 10px 0; }
        .check.pass { color: #28a745; }
        .check.fail { color: #dc3545; }
        .icon { margin-right: 10px; font-weight: bold; font-size: 18px; }
        code { background: #f3f4f6; padding: 3px 8px; border-radius: 3px; direction: ltr; }
        .box { background: #f9f9f9; padding: 15px; border-radius: 6px; margin: 10px 0; border-left: 4px solid #667eea; }
        table { width: 100%; border-collapse: collapse; margin: 15px 0; }
        table th, table td { padding: 12px; text-align: right; border-bottom: 1px solid #ddd; }
        table th { background: #f0f0f0; font-weight: bold; }
        .action-buttons { margin-top: 20px; }
        .btn { display: inline-block; padding: 10px 20px; margin-right: 10px; margin-bottom: 10px; border-radius: 6px; text-decoration: none; font-weight: bold; }
        .btn-primary { background: #667eea; color: white; }
        .btn-danger { background: #dc3545; color: white; }
        .btn:hover { opacity: 0.9; }
    </style>
</head>
<body>
<div class='container'>
<h1>📊 تقرير حالة النظام الحالية</h1>
<span class='status-badge success'>✓ النظام جاهز</span>";

// Load config and check status
require_once __DIR__ . '/../bootstrap.php';

use Parking\Config;
use Parking\Database;
use Parking\Installer;

$config = new Config();
$database = new Database($config);
$installer = new Installer(dirname(__DIR__));

// SECTION 1: Environment files
echo "<div class='section'>
<h2>📁 الملفات الأساسية</h2>";

$envExists = file_exists(dirname(__DIR__) . '/.env');
$envLocalExists = file_exists(dirname(__DIR__) . '/.env.local');

printf("<div class='check %s'><span class='icon'>%s</span> .env موجود</div>", 
    $envExists ? 'pass' : 'fail', 
    $envExists ? '✓' : '✗'
);

printf("<div class='check %s'><span class='icon'>%s</span> .env.local موجود</div>", 
    $envLocalExists ? 'fail' : 'pass', 
    $envLocalExists ? '⚠' : '✓'
);

if ($envLocalExists) {
    echo "<div class='box'>
    <strong>⚠️ ملاحظة مهمة:</strong><br>
    ملف <code>.env.local</code> موجود. هذا الملف:
    <ul style='margin-top:10px; margin-left:20px;'>
        <li>✓ <strong>جيد للتطوير المحلي</strong> (WAMP/XAMPP على حاسبك)</li>
        <li>✗ <strong>سيء على الاستضافة</strong> - يغطي إعدادات .env الصحيحة!</li>
    </ul>
    </div>";
}

// SECTION 2: Configuration
echo \"<div class='section'>
<h2>⚙️ الإعدادات المحملة</h2>\";

$appEnv = $config->get('APP_ENV');
$appUrl = $config->get('APP_URL');
$dbHost = $config->get('DB_HOST');
$dbName = $config->get('DB_NAME');
$dbUser = $config->get('DB_USER');

echo \"<table>
<tr><th>الإعداد</th><th>القيمة</th><th>النوع</th></tr>
<tr><td>APP_ENV</td><td><code>$appEnv</code></td><td>\" . (strpos($appEnv, 'local') !== false ? '🔵 محلي' : '🔴 إنتاجي') . \"</td></tr>
<tr><td>APP_URL</td><td><code>$appUrl</code></td><td>\" . (strpos($appUrl, 'localhost') !== false ? '🏠 محلي' : '🌐 استضافة') . \"</td></tr>
<tr><td>DB_HOST</td><td><code>$dbHost</code></td><td></td></tr>
<tr><td>DB_NAME</td><td><code>$dbName</code></td><td></td></tr>
<tr><td>DB_USER</td><td><code>$dbUser</code></td><td></td></tr>
</table>\";

// SECTION 3: Database Status
echo \"<div class='section'>
<h2>🗄️ قاعدة البيانات</h2>\";

try {
    \$conn = \$database->connection();
    echo \"<div class='check pass'><span class='icon'>✓</span> الاتصال بـ MySQL: ناجح</div>\";
    
    \$status = \$installer->getStatus(\$database);
    printf(\"<div class='check %s'><span class='icon'>%s</span> جداول المشروع: %s</div>\",
        \$status['tables_exist'] ? 'pass' : 'fail',
        \$status['tables_exist'] ? '✓' : '✗',
        \$status['tables_exist'] ? 'موجودة' : 'غير موجودة'
    );
    
    printf(\"<div class='check %s'><span class='icon'>%s</span> حساب الإدارة (admin): %s</div>\",
        \$status['admin_exists'] ? 'pass' : 'fail',
        \$status['admin_exists'] ? '✓' : '✗',
        \$status['admin_exists'] ? 'موجود' : 'غير موجود'
    );
    
} catch (Exception \$e) {
    echo \"<div class='check fail'><span class='icon'>✗</span> خطأ الاتصال: \" . htmlspecialchars(\$e->getMessage()) . \"</div>\";
}

// SECTION 4: System Status
echo \"<div class='section'>
<h2>✓ حالة النظام</h2>\";

\$status = \$installer->getStatus(\$database);
\$modes = [
    'fresh_install' => '⚙️ تثبيت جديد - يحتاج إعدادات',
    'needs_migration' => '📦 يحتاج ترحيلات - تشغيل migrate.php',
    'installed' => '✓ نظام جاهز - يعمل بشكل طبيعي',
];

\$modeText = \$modes[\$status['mode']] ?? 'معروف';

echo \"<div class='box'>
<strong>وضعية النظام:</strong> <code>\" . strtoupper(\$status['mode']) . \"</code>
<br><em>\$modeText</em>
</div>\";

// SECTION 5: RECOMMENDATIONS
echo \"<div class='section'>
<h2>💡 التوصيات</h2>\";

if (\$appEnv === 'local' && strpos(\$appUrl, 'localhost') === 0) {
    echo \"<div class='box'>
    ✓ أنت في بيئة <strong>التطوير المحلي</strong>
    <br><br>
    ملفات الإعدادات الحالية:
    <ul style='margin-top:10px; margin-left:20px;'>
        <li><code>.env</code> (الإنتاج - park.meezmart.com)</li>
        <li><code>.env.local</code> (التطوير المحلي - ✓ نشط الآن)</li>
    </ul>
    <br>
    <strong>إذا كنت تريد رفع إلى الاستضافة:</strong>
    <ol style='margin-top:10px; margin-left:20px;'>
        <li>احذف <code>.env.local</code> من حاسبك</li>
        <li>تحقق من إعدادات <code>.env</code></li>
        <li>رفع الملفات</li>
        <li>افتح: <code>https://park.meezmart.com/public/hosting-diagnostic.php</code></li>
        <li>قم بالإصلاح إذا لزم: <code>https://park.meezmart.com/public/hosting-fix.php</code></li>
    </ol>
    </div>\";
} else if (\$appEnv === 'production' || strpos(\$appUrl, 'meezmart') !== false) {
    echo \"<div class='box'>
    🌐 أنت إعدادات <strong>الاستضافة</strong> (meezmart)
    <br><br>
    موقع: <a href='\$appUrl' style='color:#667eea'>\$appUrl</a>
    <br><br>
    \";
    
    if (\$envLocalExists) {
        echo \"⚠️ <strong>تحذير:</strong> ملف <code>.env.local</code> موجود!
        <br>
        قد يغطي الإعدادات الصحيحة. 
        <br><br>
        <a href='hosting-fix.php?action=remove-local' class='btn btn-danger' style='margin-top:10px;'>حذف .env.local من الاستضافة</a>
        \";
    }
    
    echo \"</div>\";
}

// SECTION 6: Action Buttons
echo \"<div class='section action-buttons'>
<h2>🔧 إجراءات</h2>
<a href='hosting-diagnostic.php' class='btn btn-primary'>تشخيص الاستضافة</a>
<a href='hosting-fix.php' class='btn btn-primary'>محاولة إصلاح تلقائي</a>
<a href='../HOSTING_SETUP.md' class='btn btn-primary'>قراءة تعليمات الاستضافة</a>
<a href='../UPLOAD_CHECKLIST.md' class='btn btn-primary'>قائمة الرفع</a>
</div>\";

echo \"</div></body></html>\";
