<?php
// Centralized session bootstrap
// Sets safe cookie params and starts the session exactly once

if (session_status() === PHP_SESSION_NONE) {
    $secure = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off');

    // PHP 7.3+ supports array form
    if (PHP_VERSION_ID >= 70300) {
        session_set_cookie_params([
            'lifetime' => 0,
            'path' => '/',
            // leave domain empty to default to current host; safer across subdomains/ports
            'domain' => '',
            'secure' => $secure,
            'httponly' => true,
            'samesite' => 'Lax',
        ]);
    } else {
        // Fallback for older PHP
        session_set_cookie_params(0, '/', '', $secure, true);
    }

    // Use a custom session name to avoid conflicts (optional)
    if (session_name() === 'PHPSESSID') {
        session_name('PARKINGSESSID');
    }

    session_start();
}
