<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// MUST start session BEFORE any output
require_once __DIR__ . '/session_init.php';

// NOW we can output
header('Content-Type: text/html; charset=utf-8');
echo "<h1>Session Check</h1><pre>";

try {
    echo "1. Session loaded:\n";
    echo "   ✓ Session started\n";
    echo "   Session ID: " . session_id() . "\n\n";
    
    echo "2. Session data:\n";
    if (empty($_SESSION)) {
        echo "   ⚠ Session is EMPTY\n";
    } else {
        foreach ($_SESSION as $key => $value) {
            echo "   $key = $value\n";
        }
    }
    echo "\n";
    
    echo "3. Login status:\n";
    if (isset($_SESSION['admin_id'])) {
        echo "   ✓ Admin logged in (ID: {$_SESSION['admin_id']})\n";
    } elseif (isset($_SESSION['coordinator_id'])) {
        echo "   ✓ Coordinator logged in (ID: {$_SESSION['coordinator_id']})\n";
    } else {
        echo "   ✗ NOT logged in\n";
        echo "   → Please login at: <a href='login.php'>login.php</a>\n";
    }
    
    echo "\n4. Cookies:\n";
    if (isset($_COOKIE['PARKINGSESSID'])) {
        echo "   ✓ Cookie found: PARKINGSESSID\n";
    } else {
        echo "   ✗ No PARKINGSESSID cookie\n";
    }
    
    echo "\n✓ All basic checks passed!\n";
    
} catch (Throwable $e) {
    echo "\n❌ ERROR:\n";
    echo "   " . $e->getMessage() . "\n";
    echo "   File: " . $e->getFile() . " (Line " . $e->getLine() . ")\n";
}

echo "</pre>";
