<?php
// Check PHP configuration and Apache settings
header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Server Configuration Check</title>
    <style>
        body { font-family: monospace; padding: 20px; background: #1a1a1a; color: #0f0; }
        h1 { color: #0ff; }
        h2 { color: #ff0; margin-top: 30px; }
        pre { background: #000; padding: 10px; overflow: auto; border: 1px solid #0f0; }
        .section { background: #2a2a2a; padding: 15px; margin: 10px 0; border-left: 4px solid #0f0; }
        .error { border-left-color: #f00; color: #f00; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #0f0; padding: 8px; text-align: left; }
        th { background: #333; }
    </style>
</head>
<body>
    <h1>Server Configuration Analysis</h1>
    
    <h2>1. Apache Modules</h2>
    <div class="section">
        <?php
        if (function_exists('apache_get_modules')) {
            $modules = apache_get_modules();
            echo "<pre>" . implode("\n", $modules) . "</pre>";
            
            if (in_array('mod_rewrite', $modules)) {
                echo "<p style='color:#ff0;'>⚠️ mod_rewrite is ENABLED</p>";
            }
        } else {
            echo "<p>apache_get_modules() not available</p>";
        }
        ?>
    </div>
    
    <h2>2. PHP Configuration (auto_prepend/append)</h2>
    <div class="section">
        <?php
        $prepend = ini_get('auto_prepend_file');
        $append = ini_get('auto_append_file');
        
        echo "<table>";
        echo "<tr><th>Setting</th><th>Value</th></tr>";
        echo "<tr><td>auto_prepend_file</td><td>" . ($prepend ?: '<em>none</em>') . "</td></tr>";
        echo "<tr><td>auto_append_file</td><td>" . ($append ?: '<em>none</em>') . "</td></tr>";
        echo "</table>";
        
        if ($prepend || $append) {
            echo "<p class='error'>⚠️ There is an auto_prepend or auto_append file that might be causing redirects!</p>";
        }
        ?>
    </div>
    
    <h2>3. Environment Variables</h2>
    <div class="section">
        <pre><?php print_r($_ENV); ?></pre>
    </div>
    
    <h2>4. Server API</h2>
    <div class="section">
        <?php
        echo "Server API: " . php_sapi_name() . "<br>";
        echo "Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "<br>";
        ?>
    </div>
    
    <h2>5. All $_SERVER Variables</h2>
    <div class="section">
        <pre><?php print_r($_SERVER); ?></pre>
    </div>
    
    <h2>6. Check DirectoryIndex Order</h2>
    <div class="section">
        <?php
        echo "<p>When you access http://park.meezmart.com/, Apache looks for files in this order:</p>";
        echo "<ol>";
        echo "<li>index.php (should be found)</li>";
        echo "<li>index.html (not present)</li>";
        echo "</ol>";
        echo "<p>Current script: " . $_SERVER['SCRIPT_FILENAME'] . "</p>";
        ?>
    </div>
    
    <h2>7. Test: What happens when we include index.php?</h2>
    <div class="section">
        <?php
        echo "<p>Let's see what index.php would do...</p>";
        
        // Capture output
        ob_start();
        try {
            // Don't execute, just check if it would redirect
            $indexContent = file_get_contents(__DIR__ . '/index.php');
            
            // Check for meta refresh
            if (preg_match('/<meta[^>]*http-equiv=["\']refresh["\'][^>]*>/i', $indexContent)) {
                echo "<p class='error'>❌ Found meta refresh in index.php!</p>";
            }
            
            // Check for JavaScript redirect
            if (preg_match('/window\.location|document\.location/i', $indexContent)) {
                echo "<p class='error'>❌ Found JavaScript redirect in index.php!</p>";
            }
            
            echo "<p style='color:#0f0;'>✓ No HTML/JS redirects found in index.php</p>";
            
        } catch (Exception $e) {
            echo "<p class='error'>Error: " . $e->getMessage() . "</p>";
        }
        ob_end_flush();
        ?>
    </div>
    
    <h2>8. Recommendation</h2>
    <div class="section">
        <p><strong>If you still get redirected to admin-dashboard.php:</strong></p>
        <ol>
            <li>Check cPanel → Redirects (should be empty)</li>
            <li>Check if there's a .htaccess in parent directory: /home/meezma5/park.meezmart.com/.htaccess</li>
            <li>Contact hosting support - there might be a server-level redirect</li>
        </ol>
    </div>
    
</body>
</html>
