<?php
// Pure HTML test - NO PHP execution
header('Content-Type: text/html; charset=utf-8');
?><!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <title>Pure HTML Test</title>
    <style>
        body { font-family: Arial; padding: 50px; text-align: center; background: #0f172a; color: white; }
        .box { background: white; color: #333; padding: 40px; border-radius: 10px; max-width: 600px; margin: 0 auto; }
        h1 { color: #00cc66; }
        .btn { display: inline-block; padding: 15px 30px; margin: 10px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; }
    </style>
</head>
<body>
    <div class="box">
        <h1>✓ Pure HTML Test Works!</h1>
        <p><strong>Current URL:</strong> <span id="url"></span></p>
        <p><strong>Current Time:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>
        <hr>
        <p>If you see this page, it means:</p>
        <ul style="text-align: left;">
            <li>✓ PHP is executing</li>
            <li>✓ No redirect is happening at Apache level</li>
            <li>✓ The problem is in PHP code itself</li>
        </ul>
        <hr>
        <a href="index.php?test=1" class="btn">Test index.php</a>
        <a href="full-diagnostic.php" class="btn">Full Diagnostic</a>
    </div>
    
    <script>
        document.getElementById('url').textContent = window.location.href;
        
        // Check if we're being redirected
        let redirectCount = parseInt(sessionStorage.getItem('redirectCount') || '0');
        if (redirectCount > 0) {
            document.body.innerHTML += '<div style="background:red;color:white;padding:20px;margin:20px;border-radius:10px;"><h2>⚠️ REDIRECT LOOP DETECTED!</h2><p>This page has been loaded ' + redirectCount + ' times</p></div>';
        }
        redirectCount++;
        sessionStorage.setItem('redirectCount', redirectCount);
    </script>
</body>
</html>
