<?php
require_once __DIR__ . '/session_init.php';

use Parking\Auth;
use Parking\Database;
use Parking\Config;
use Parking\Installer;

$container = require __DIR__ . '/../bootstrap.php';
$config = $container['config'];
$database = $container['database'];

$installer = new Installer(dirname(__DIR__));
if (!$installer->isInstalled($database)) {
    header('Location: install.php');
    exit;
}

$auth = new Auth($database);

// Ensure session is started for admin login checks
// session is started in session_init.php

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($username === '' || $password === '') {
        $error = 'الرجاء إدخال اسم المستخدم وكلمة المرور';
    } elseif ($auth->login($username, $password)) {
        header('Location: admin-dashboard.php');
        exit;
    } else {
        $error = 'اسم المستخدم أو كلمة المرور غير صحيحة';
    }
}

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - نظام الباركنج</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" href="assets/theme.css">
    <link rel="stylesheet" href="assets/login.css">
</head>
<body>
    <!-- Animated background particles -->
    <div class="particles">
        <div class="particle" style="width: 80px; height: 80px; left: 10%; top: 20%; animation-delay: 0s;"></div>
        <div class="particle" style="width: 60px; height: 60px; left: 80%; top: 30%; animation-delay: 2s;"></div>
        <div class="particle" style="width: 100px; height: 100px; left: 50%; top: 60%; animation-delay: 4s;"></div>
        <div class="particle" style="width: 70px; height: 70px; left: 20%; top: 80%; animation-delay: 6s;"></div>
        <div class="particle" style="width: 90px; height: 90px; left: 85%; top: 70%; animation-delay: 3s;"></div>
    </div>

    <div class="login-container">
        <div class="login-card">
            <div class="logo-container">
                <div style="width: 64px; height: 64px; background: var(--brand-gradient); border-radius: 16px; display: flex; align-items: center; justify-content: center; margin: 0 auto 16px;">
                    <span class="material-icons" style="font-size: 36px; color: #fff;">local_parking</span>
                </div>
                <h1 class="login-title">شركة الخليج</h1>
                <p class="login-subtitle">نظام إدارة مواقف السيارات</p>
            </div>

            <?php if ($error): ?>
                <div class="error-message">
                    <span class="material-icons">error</span>
                    <span><?php echo htmlspecialchars($error, ENT_QUOTES, 'UTF-8'); ?></span>
                </div>
            <?php endif; ?>

            <form method="POST" action="login.php">
                <div class="form-group">
                    <label for="username" class="form-label">
                        <span class="material-icons">person</span>
                        اسم المستخدم
                    </label>
                    <input 
                        type="text" 
                        id="username" 
                        name="username" 
                        class="form-input" 
                        placeholder="أدخل اسم المستخدم"
                        value="<?php echo htmlspecialchars($_POST['username'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                        required
                        autofocus
                    >
                    <span class="input-icon">
                        <span class="material-icons">person</span>
                    </span>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">
                        <span class="material-icons">lock</span>
                        كلمة المرور
                    </label>
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        class="form-input" 
                        placeholder="أدخل كلمة المرور"
                        required
                    >
                    <span class="input-icon">
                        <span class="material-icons">lock</span>
                    </span>
                </div>

                <button type="submit" class="btn-login">
                    <span class="material-icons">login</span>
                    تسجيل الدخول
                </button>
            </form>

            <div class="footer-text">
                <span class="material-icons">security</span>
                تسجيل الدخول آمن ومشفّر
            </div>

            <div class="divider">
                <a href="coordinator-login.php" class="switch-link">
                    <span class="material-icons">badge</span>
                    تسجيل دخول المنسق
                </a>
            </div>
        </div>
    </div>

    <script>
        // Add loading state on form submit
        document.querySelector('form').addEventListener('submit', function(e) {
            const btn = document.querySelector('.btn-login');
            btn.classList.add('loading');
            btn.textContent = 'جاري التحقق...';
        });

        // Add focus animation
        document.querySelectorAll('.form-input').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.querySelector('.form-label').style.color = 'var(--primary)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.querySelector('.form-label').style.color = 'var(--text-secondary)';
            });
        });
    </script>
</body>
</html>
