<?php
// Check what happens when we access index.php
// This will intercept and log everything

ob_start();

echo "=== LOADING index.php ===\n\n";

// Capture any redirects
$redirected = false;
$redirectLocation = '';

// Override header function
function custom_header($header) {
    global $redirected, $redirectLocation;
    if (stripos($header, 'Location:') === 0) {
        $redirected = true;
        $redirectLocation = trim(substr($header, 9));
        echo "!!! REDIRECT DETECTED !!!\n";
        echo "Redirecting to: $redirectLocation\n\n";
    }
}

echo "Step 1: Starting session...\n";
session_start();
echo "Session ID: " . session_id() . "\n";
echo "Session Data: " . print_r($_SESSION, true) . "\n";

echo "\nStep 2: Loading bootstrap...\n";
require __DIR__ . '/../bootstrap.php';
echo "Bootstrap loaded\n";

echo "\nStep 3: Getting database...\n";
$database = $GLOBALS['container']['database'] ?? null;
if ($database) {
    echo "Database object obtained\n";
} else {
    echo "ERROR: No database object!\n";
}

echo "\nStep 4: Checking installer...\n";
require_once __DIR__ . '/../src/Installer.php';
$installer = new \Parking\Installer(dirname(__DIR__));
$isInstalled = $installer->isInstalled($database);
echo "Installation status: " . ($isInstalled ? 'INSTALLED' : 'NOT INSTALLED') . "\n";

if (!$isInstalled) {
    echo "!!! WOULD REDIRECT TO install.php !!!\n";
}

echo "\n=== END OF CHECKS ===\n\n";

if ($redirected) {
    echo "\n\n!!! A REDIRECT WAS ATTEMPTED !!!\n";
    echo "Target: $redirectLocation\n";
} else {
    echo "\n\n=== NO REDIRECT - index.php should display normally ===\n";
}

$output = ob_get_clean();

header('Content-Type: text/plain; charset=utf-8');
echo $output;
