<?php
/**
 * Sidebar Component - نظام الباركنج - شركة الخليج
 * Used across all admin and coordinator pages
 */

$currentPage = $currentPage ?? '';
$userFullName = $userFullName ?? 'مستخدم';
$isAdmin = $isAdmin ?? true;
?>
<!-- Sidebar -->
<aside class="sidebar" id="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo brand-bar">
            <div style="width: 36px; height: 36px; background: var(--brand-gradient); border-radius: 10px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                <span class="material-icons" style="font-size: 22px; color: #fff;">local_parking</span>
            </div>
            <span class="brand-name">شركة الخليج</span>
        </div>

        <?php if (isset($activeEvent) && $activeEvent): ?>
            <div style="padding: 12px 20px; background: rgba(108, 99, 255, 0.04); border-bottom: 1px solid var(--border);">
                <div style="font-size: 10px; color: var(--text-muted); margin-bottom: 6px; text-transform: uppercase; letter-spacing: 0.5px; font-weight: 700;">
                    الحدث النشط
                </div>
                <div style="display: flex; align-items: center; gap: 10px;">
                    <?php if (!empty($activeEvent['logo'])): ?>
                        <img src="<?php echo htmlspecialchars($activeEvent['logo']); ?>" alt="" style="width: 32px; height: 32px; object-fit: contain; background: rgba(255,255,255,0.04); border-radius: 8px; padding: 3px;" />
                    <?php endif; ?>
                    <div style="flex: 1; min-width: 0;">
                        <div style="font-size: 13px; font-weight: 700; color: var(--text-primary); white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                            <?php echo htmlspecialchars($activeEvent['name']); ?>
                        </div>
                        <?php if (!empty($activeEvent['event_date'])): ?>
                            <div style="font-size: 11px; color: var(--text-muted); display: flex; align-items: center; gap: 4px; margin-top: 2px;">
                                <span class="material-icons" style="font-size: 12px;">event</span>
                                <?php echo htmlspecialchars($activeEvent['event_date']); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <nav>
        <div style="padding: 8px 20px 4px; font-size: 10px; color: var(--text-muted); text-transform: uppercase; letter-spacing: 1px; font-weight: 700;">
            القائمة الرئيسية
        </div>
        <ul class="sidebar-menu">
            <?php if ($isAdmin): ?>
                <li class="menu-item">
                    <a href="admin-dashboard.php" class="menu-link <?php echo $currentPage === 'admin-dashboard' ? 'active' : ''; ?>">
                        <span class="material-icons menu-icon">space_dashboard</span>
                        <span>لوحة التحكم</span>
                    </a>
                </li>
            <?php endif; ?>

            <li class="menu-item">
                <a href="dashboard.php" class="menu-link <?php echo $currentPage === 'dashboard' ? 'active' : ''; ?>">
                    <span class="material-icons menu-icon">monitor_heart</span>
                    <span>الشاشة المباشرة</span>
                </a>
            </li>
            <li class="menu-item">
                <a href="register-vehicle.php" class="menu-link <?php echo $currentPage === 'register-vehicle' ? 'active' : ''; ?>">
                    <span class="material-icons menu-icon">add_circle_outline</span>
                    <span>تسجيل سيارة</span>
                </a>
            </li>

            <?php if ($isAdmin): ?>
                <div style="padding: 16px 20px 4px; font-size: 10px; color: var(--text-muted); text-transform: uppercase; letter-spacing: 1px; font-weight: 700;">
                    الإدارة
                </div>
                <li class="menu-item">
                    <a href="clients.php" class="menu-link <?php echo $currentPage === 'clients' ? 'active' : ''; ?>">
                        <span class="material-icons menu-icon">corporate_fare</span>
                        <span>الشركات</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="events.php" class="menu-link <?php echo $currentPage === 'events' ? 'active' : ''; ?>">
                        <span class="material-icons menu-icon">celebration</span>
                        <span>الفعاليات</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="coordinators.php" class="menu-link <?php echo $currentPage === 'coordinators' ? 'active' : ''; ?>">
                        <span class="material-icons menu-icon">badge</span>
                        <span>المنسقين</span>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </nav>

    <div class="sidebar-footer">
        <div style="display: flex; align-items: center; justify-content: space-between; padding: 14px 20px;">
            <div style="display: flex; align-items: center; gap: 10px; flex: 1; min-width: 0;">
                <div style="width: 36px; height: 36px; border-radius: 10px; background: var(--brand-gradient); display: flex; align-items: center; justify-content: center; color: #fff; font-weight: 800; font-size: 15px; flex-shrink: 0;">
                    <?php echo mb_substr($userFullName, 0, 1); ?>
                </div>
                <div style="flex: 1; min-width: 0;">
                    <div style="font-size: 13px; font-weight: 700; color: var(--text-primary); white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                        <?php echo htmlspecialchars($userFullName, ENT_QUOTES, 'UTF-8'); ?>
                    </div>
                    <div style="font-size: 11px; color: var(--text-muted); font-weight: 600;">
                        <?php echo $isAdmin ? 'مدير النظام' : 'منسق'; ?>
                    </div>
                </div>
            </div>
            <form method="POST" action="<?php echo $isAdmin ? 'logout.php' : 'coordinator-logout.php'; ?>" style="margin: 0;">
                <button type="submit" class="btn btn-danger btn-icon" style="padding: 6px;" title="تسجيل الخروج">
                    <span class="material-icons" style="font-size: 18px;">logout</span>
                </button>
            </form>
        </div>
    </div>
</aside>
