<?php
/**
 * Hosting Diagnostic Script
 * Upload this to the hosting server to diagnose the issue
 */

echo "<!DOCTYPE html>
<html lang='ar' dir='rtl'>
<head>
    <meta charset='UTF-8'>
    <title>تشخيص النظام - الاستضافة</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: Tahoma, Arial; background: #f5f5f5; padding: 20px; direction: rtl; }
        .container { max-width: 900px; margin: 0 auto; background: white; border-radius: 8px; padding: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1 { color: #333; margin-bottom: 20px; border-bottom: 2px solid #6366f1; padding-bottom: 10px; }
        h2 { color: #666; margin-top: 20px; margin-bottom: 10px; }
        .check { display: flex; align-items: center; padding: 8px 0; font-size: 14px; }
        .pass { color: #10b981; }
        .fail { color: #ef4444; }
        .icon { margin-right: 8px; font-weight: bold; }
        code { background: #f3f4f6; padding: 2px 6px; border-radius: 3px; direction: ltr; }
        .alert { padding: 12px; margin-bottom: 10px; border-radius: 4px; }
        .alert-error { background: #fee; border: 1px solid #fcc; color: #c33; }
        .alert-info { background: #eef; border: 1px solid #ccf; color: #33c; }
        .alert-success { background: #efe; border: 1px solid #cfc; color: #3c3; }
        table { width: 100%; border-collapse: collapse; margin: 10px 0; }
        table th, table td { padding: 10px; text-align: right; border-bottom: 1px solid #ddd; }
        table th { background: #f9f9f9; font-weight: bold; }
    </style>
</head>
<body>
<div class='container'>";

// 1. Check files
echo "<h1>🔍 تشخيص النظام على الاستضافة</h1>";

echo "<h2>✓ الملفات</h2>";
$envCheck = file_exists('../.env');
$envLocalCheck = file_exists('../.env.local');
printf("<div class='check %s'><span class='icon'>%s</span> ملف .env: %s</div>", 
    $envCheck ? 'pass' : 'fail', 
    $envCheck ? '✓' : '✗', 
    $envCheck ? 'موجود' : '<strong>غير موجود!</strong>'
);
printf("<div class='check %s'><span class='icon'>%s</span> ملف .env.local: %s</div>", 
    $envLocalCheck ? 'pass' : 'fail', 
    $envLocalCheck ? '✓' : '✗', 
    $envLocalCheck ? 'موجود (قد يغطي إعدادات الاستضافة)' : 'غير موجود'
);

// 2. Load config
echo "<h2>📋 الإعدادات المحملة</h2>";
require_once __DIR__ . '/../bootstrap.php';
use Parking\Config;
$config = new Config();

$dbHost = $config->get('DB_HOST', 'N/A');
$dbPort = $config->get('DB_PORT', 'N/A');  
$dbName = $config->get('DB_NAME', 'N/A');
$dbUser = $config->get('DB_USER', 'N/A');
$dbPass = $config->get('DB_PASSWORD', 'N/A');

echo "<table>
<tr><th>الإعداد</th><th>القيمة</th></tr>
<tr><td>Host</td><td><code>$dbHost</code></td></tr>
<tr><td>Port</td><td><code>$dbPort</code></td></tr>
<tr><td>Database</td><td><code>$dbName</code></td></tr>
<tr><td>User</td><td><code>$dbUser</code></td></tr>
<tr><td>Password</td><td>" . (strlen($dbPass) > 0 ? '••••••••' : '[فارغة]') . "</td></tr>
</table>";

// 3. Test connection
echo "<h2>🔗 اتصال قاعدة البيانات</h2>";
try {
    use Parking\Database;
    $database = new Database($config);
    $conn = $database->connection();
    echo "<div class='alert alert-success'>✓ اتصال ناجح بـ MySQL</div>";
    
    // Check if database exists
    $stmt = $conn->query("SELECT 1");
    echo "<div class='alert alert-success'>✓ قاعدة البيانات '<code>$dbName</code>' موجودة</div>";
    
    // Check tables
    $stmt = $conn->query("SHOW TABLES");
    $tables = $stmt->fetchAll();
    echo "<div class='check pass'><span class='icon'>✓</span> عدد الجداول: " . count($tables) . "</div>";
    
    if (count($tables) > 0) {
        echo "<table><tr><th>اسم الجدول</th></tr>";
        foreach ($tables as $table) {
            echo "<tr><td><code>" . reset($table) . "</code></td></tr>";
        }
        echo "</table>";
    }
    
} catch (Exception $e) {
    echo "<div class='alert alert-error'>✗ خطأ: " . $e->getMessage() . "</div>";
}

// 4. Installation status
echo "<h2>⚙️ حالة التثبيت</h2>";
try {
    use Parking\Installer;
    $installer = new Installer(dirname(__DIR__));
    $status = $installer->getStatus($database);
    
    echo "<table>
    <tr><th>المتغير</th><th>الحالة</th></tr>
    <tr><td>ملف .env موجود</td><td>" . ($status['env_exists'] ? '✓ نعم' : '✗ لا') . "</td></tr>
    <tr><td>اتصال قاعدة البيانات</td><td>" . ($status['db_connected'] ? '✓ نعم' : '✗ لا') . "</td></tr>
    <tr><td>الجداول موجودة</td><td>" . ($status['tables_exist'] ? '✓ نعم' : '✗ لا') . "</td></tr>
    <tr><td>حساب admin موجود</td><td>" . ($status['admin_exists'] ? '✓ نعم' : '✗ لا') . "</td></tr>
    <tr><td>وضعية النظام</td><td><strong>" . strtoupper($status['mode']) . "</strong></td></tr>
    </table>";
    
    if ($status['error']) {
        echo "<div class='alert alert-error'>خطأ: " . $status['error'] . "</div>";
    }
} catch (Exception $e) {
    echo "<div class='alert alert-error'>خطأ: " . $e->getMessage() . "</div>";
}

echo "</div></body></html>";
