<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">
    <title>تنظيف الكاش</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; padding: 20px; }
        .container { background: white; padding: 40px; border-radius: 20px; box-shadow: 0 20px 60px rgba(0,0,0,0.3); max-width: 600px; width: 100%; text-align: center; }
        h1 { color: #333; margin-bottom: 20px; font-size: 2em; }
        .success { color: #28a745; font-size: 4em; margin-bottom: 20px; }
        .info { background: #e7f3ff; padding: 20px; border-radius: 10px; margin: 20px 0; text-align: right; }
        .info h3 { color: #0066cc; margin-bottom: 10px; }
        .info ol { margin-right: 20px; line-height: 2; }
        .btn { display: inline-block; padding: 15px 30px; margin: 10px; background: #007bff; color: white; text-decoration: none; border-radius: 10px; font-size: 1.1em; transition: all 0.3s; }
        .btn:hover { background: #0056b3; transform: translateY(-2px); box-shadow: 0 5px 15px rgba(0,123,255,0.3); }
        .btn-success { background: #28a745; }
        .btn-success:hover { background: #218838; }
        .warning { background: #fff3cd; border: 2px solid #ffc107; padding: 15px; border-radius: 10px; margin: 20px 0; color: #856404; }
    </style>
</head>
<body>
    <div class="container">
        <div class="success">✓</div>
        <h1>تم تنظيف النظام بنجاح!</h1>
        
        <div class="warning">
            <strong>⚠️ مهم جداً:</strong><br>
            يجب تنظيف ذاكرة التخزين المؤقت (Cache) في المتصفح!
        </div>
        
        <div class="info">
            <h3>خطوات تنظيف الكاش:</h3>
            <ol>
                <li>اضغط <strong>Ctrl + Shift + Delete</strong></li>
                <li>اختر "ذاكرة التخزين المؤقت" و "ملفات الكوكيز"</li>
                <li>اضغط "مسح البيانات"</li>
                <li><strong>أو</strong> أغلق المتصفح تماماً وافتحه من جديد</li>
                <li><strong>أو</strong> استخدم وضع التصفح الخفي (Incognito)</li>
            </ol>
        </div>
        
        <hr style="margin: 30px 0; border: none; border-top: 1px solid #eee;">
        
        <h2 style="margin-bottom: 20px;">اختبر النظام:</h2>
        <a href="index.php?t=<?php echo time(); ?>" class="btn btn-success">الصفحة الرئيسية</a>
        <a href="login.php?t=<?php echo time(); ?>" class="btn">تسجيل دخول Admin</a>
        <a href="coordinator-login.php?t=<?php echo time(); ?>" class="btn">تسجيل دخول منسق</a>
    </div>
    
    <script>
        // Clear any cached data
        if ('caches' in window) {
            caches.keys().then(function(names) {
                names.forEach(function(name) {
                    caches.delete(name);
                });
            });
        }
        
        // Add timestamp to links to bypass cache
        document.querySelectorAll('a').forEach(link => {
            const url = new URL(link.href);
            url.searchParams.set('nocache', Date.now());
            link.href = url.toString();
        });
    </script>
</body>
</html>
