<?php
require_once __DIR__ . '/session_init.php';

use Parking\Database;
use Parking\CoordinatorRepository;

// If already logged in as coordinator, redirect to coordinator dashboard
if (isset($_SESSION['coordinator_id'])) {
    header('Location: coordinator-dashboard.php');
    exit;
}

$container = require __DIR__ . '/../bootstrap.php';
$database = $container['database'];
$coordinatorRepo = new CoordinatorRepository($database);

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $coordinator = $coordinatorRepo->verifyLogin($username, $password);
    
    if ($coordinator) {
        $_SESSION['coordinator_id'] = $coordinator['id'];
        $_SESSION['coordinator_name'] = $coordinator['full_name'];
        
        header('Location: coordinator-dashboard.php');
        exit;
    } else {
        $error = 'اسم المستخدم أو كلمة المرور غير صحيحة';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل دخول المنسق - نظام الباركنج</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" href="assets/theme.css">
    <link rel="stylesheet" href="assets/login.css">
</head>
<body>
    <!-- Animated background particles -->
    <div class="particles">
        <div class="particle" style="width: 80px; height: 80px; left: 10%; top: 20%; animation-delay: 0s;"></div>
        <div class="particle" style="width: 60px; height: 60px; left: 80%; top: 30%; animation-delay: 2s;"></div>
        <div class="particle" style="width: 100px; height: 100px; left: 50%; top: 60%; animation-delay: 4s;"></div>
        <div class="particle" style="width: 70px; height: 70px; left: 20%; top: 80%; animation-delay: 6s;"></div>
        <div class="particle" style="width: 90px; height: 90px; left: 85%; top: 70%; animation-delay: 3s;"></div>
    </div>

    <div class="login-container" style="max-width: 400px; margin: 40px auto; padding: 0;">
        <div class="login-card" style="padding: 32px 24px 24px 24px;">
            <div class="logo-container" style="text-align: center; margin-bottom: 18px;">
                <div style="width: 64px; height: 64px; background: var(--brand-gradient); border-radius: 16px; display: flex; align-items: center; justify-content: center; margin: 0 auto 12px;">
                    <span class="material-icons" style="font-size: 36px; color: #fff;">badge</span>
                </div>
                <h1 class="login-title">شركة الخليج</h1>
                <p class="login-subtitle" style="font-size: 1.2rem; margin: 0; color: var(--brand-primary); letter-spacing: 1px;">
                    لوحة تحكم المنسق
                </p>
            </div>

            <?php if ($error): ?>
                <div class="error-message">
                    <span class="material-icons">error</span>
                    <span><?php echo htmlspecialchars($error); ?></span>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label for="username" class="form-label">
                        <span class="material-icons">account_circle</span>
                        اسم المستخدم
                    </label>
                    <input 
                        type="text" 
                        id="username" 
                        name="username" 
                        class="form-input"
                        required 
                        autofocus
                        placeholder="أدخل اسم المستخدم"
                        value="<?php echo htmlspecialchars($_POST['username'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
                    >
                    <span class="input-icon">
                        <span class="material-icons">account_circle</span>
                    </span>
                </div>

                <div class="form-group">
                    <label for="password" class="form-label">
                        <span class="material-icons">lock</span>
                        كلمة المرور
                    </label>
                    <input 
                        type="password" 
                        id="password" 
                        name="password" 
                        class="form-input"
                        required
                        placeholder="أدخل كلمة المرور"
                    >
                    <span class="input-icon">
                        <span class="material-icons">lock</span>
                    </span>
                </div>

                <button type="submit" class="btn-login">
                    <span class="material-icons">login</span>
                    تسجيل الدخول
                </button>
            </form>

            <div class="footer-text">
                <span class="material-icons">badge</span>
                تسجيل دخول خاص بالمنسقين
            </div>

            <div class="divider">
                <a href="login.php" class="switch-link">
                    <span class="material-icons">admin_panel_settings</span>
                    تسجيل دخول الإدارة
                </a>
            </div>
        </div>
    </div>

    <script>
        // Add loading state on form submit
        document.querySelector('form').addEventListener('submit', function(e) {
            const btn = document.querySelector('.btn-login');
            btn.classList.add('loading');
            btn.innerHTML = '<span class="material-icons" style="animation: spin 1s linear infinite;">hourglass_empty</span> جاري التحقق...';
        });

        // Add focus animation
        document.querySelectorAll('.form-input').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.querySelector('.form-label').style.color = 'var(--primary)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.querySelector('.form-label').style.color = 'var(--dark)';
            });
        });
    </script>
</body>
</html>
