<?php
/**
 * System Requirements Checker
 * Displays detailed information about PHP and required extensions
 */

// Prevent output buffering
if (ob_get_level()) {
    ob_end_clean();
}

header('Content-Type: text/plain; charset=utf-8');

echo "=== Parking Management System - Requirements Check ===\n\n";

// PHP Version
echo "PHP Version: " . PHP_VERSION . "\n";
echo "Required: 7.4.0 or later\n";
echo "Status: " . (version_compare(PHP_VERSION, '7.4.0', '>=') ? "✓ PASS" : "✗ FAIL") . "\n\n";

// PDO Extension
echo "PDO Extension:\n";
echo "  - Loaded: " . (extension_loaded('pdo') ? "✓ Yes" : "✗ No") . "\n";

// PDO SQLite Driver
echo "PDO SQLite Driver:\n";
echo "  - Loaded: " . (extension_loaded('pdo_sqlite') ? "✓ Yes" : "✗ No") . "\n";

if (!extension_loaded('pdo_sqlite')) {
    echo "\n⚠️  PDO SQLite is not loaded!\n";
    echo "To enable it:\n";
    echo "  1. Find your php.ini file\n";
    echo "  2. Look for: ;extension=pdo_sqlite\n";
    echo "  3. Uncomment it (remove the semicolon)\n";
    echo "  4. Restart your web server\n";
}

// File System Permissions
echo "\nFile System Permissions:\n";
$projectRoot = dirname(__DIR__);
echo "  - Project Root: " . $projectRoot . "\n";
echo "  - Writable: " . (is_writable($projectRoot) ? "✓ Yes" : "✗ No") . "\n";

$dataDir = $projectRoot . '/data';
if (is_dir($dataDir)) {
    echo "  - Data Directory: " . $dataDir . " (✓ Exists)\n";
    echo "  - Data Directory Writable: " . (is_writable($dataDir) ? "✓ Yes" : "✗ No") . "\n";
} else {
    echo "  - Data Directory: " . $dataDir . " (✗ Does not exist)\n";
}

// .env File
echo "\nConfiguration:\n";
$envPath = $projectRoot . '/.env';
if (file_exists($envPath)) {
    echo "  - .env file: ✓ Exists\n";
} else {
    echo "  - .env file: ✗ Does not exist\n";
}

// Database File
$dbPath = $projectRoot . '/data/parking.db';
if (file_exists($dbPath)) {
    echo "  - Database file: ✓ Exists\n";
    echo "  - Database size: " . filesize($dbPath) . " bytes\n";
} else {
    echo "  - Database file: ✗ Does not exist\n";
}

echo "\n=== End of Requirements Check ===\n";
echo "\nIf you see any ✗ (FAIL) or ✗ (No), please fix those before installing.\n";
echo "Create .env then run php migrate.php (CLI) or open /public/manual-migrate.php?token=YOUR_TOKEN to complete installation.\n";
