<?php
// Check for .htaccess files and redirects
echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>Check .htaccess</title>";
echo "<style>body{font-family:monospace;padding:20px;background:#f5f5f5;} .box{background:white;padding:15px;margin:10px 0;border-radius:5px;} pre{background:#f8f9fa;padding:10px;overflow:auto;}</style>";
echo "</head><body><h1>Checking for .htaccess Files</h1>";

$paths = [
    $_SERVER['DOCUMENT_ROOT'] . '/.htaccess',
    $_SERVER['DOCUMENT_ROOT'] . '/parking/.htaccess',
    $_SERVER['DOCUMENT_ROOT'] . '/parking/public/.htaccess',
    dirname(__DIR__) . '/.htaccess',
    __DIR__ . '/.htaccess',
];

foreach ($paths as $path) {
    echo "<div class='box'>";
    echo "<strong>Path:</strong> " . htmlspecialchars($path) . "<br>";
    
    if (file_exists($path)) {
        echo "<span style='color:green;'>✓ EXISTS</span><br>";
        echo "<strong>Content:</strong><pre>" . htmlspecialchars(file_get_contents($path)) . "</pre>";
    } else {
        echo "<span style='color:gray;'>✗ Not found</span>";
    }
    echo "</div>";
}

echo "<hr><h2>Server Variables:</h2>";
echo "<div class='box'><pre>";
echo "DOCUMENT_ROOT: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'N/A') . "\n";
echo "SCRIPT_FILENAME: " . ($_SERVER['SCRIPT_FILENAME'] ?? 'N/A') . "\n";
echo "REQUEST_URI: " . ($_SERVER['REQUEST_URI'] ?? 'N/A') . "\n";
echo "REDIRECT_URL: " . ($_SERVER['REDIRECT_URL'] ?? 'N/A') . "\n";
echo "REDIRECT_STATUS: " . ($_SERVER['REDIRECT_STATUS'] ?? 'N/A') . "\n";
echo "</pre></div>";

echo "</body></html>";
