<?php

declare(strict_types=1);

// Log errors instead of displaying them to prevent HTML in JSON response
ini_set('display_errors', '0');
ini_set('log_errors', '1');
error_reporting(E_ALL);

use Parking\Installer;
use Parking\ParkingRepository;
use Parking\CoordinatorRepository;

try {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }

    $container = require __DIR__ . '/../../bootstrap.php';
    $database = $container['database'];
} catch (Throwable $e) {
    header('Content-Type: application/json; charset=utf-8');
    http_response_code(500);
    echo json_encode(['error' => 'خطأ في الخادم']);
    exit;
}

$installer = new Installer(dirname(__DIR__, 2));

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');

if (!$installer->isInstalled($database)) {
    http_response_code(503);
    echo json_encode(['error' => 'التطبيق غير مُعد بعد.']);
    exit;
}

$scope = $_GET['scope'] ?? 'all';

// Check if coordinator is logged in to filter by their tickets
$coordinatorEventId = null;
$coordinatorId = null;
if (isset($_SESSION['coordinator_id'])) {
    $coordinatorRepo = new CoordinatorRepository($database);
    $coordinator = $coordinatorRepo->getCoordinatorById($_SESSION['coordinator_id']);
    if ($coordinator) {
        $coordinatorEventId = $coordinator['event_id'] !== null ? (int)$coordinator['event_id'] : null;
        $coordinatorId = $coordinator['id'] !== null ? (int)$coordinator['id'] : null;
    }
}

try {
    $repository = new ParkingRepository($database);

    if ($scope === 'active') {
        // Coordinator sees only their own tickets, Admin sees all tickets
        $tickets = $repository->getActiveTickets($coordinatorEventId, $coordinatorId);
    } else {
        // Coordinator sees only their own tickets, Admin sees all tickets
        $tickets = $repository->getAllTickets($coordinatorEventId, $coordinatorId);
    }

    echo json_encode([
        'tickets' => $tickets,
    ], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'خطأ في قاعدة البيانات',
        'message' => 'حدث خطأ أثناء جلب البيانات'
    ]);
}
