<?php

$autoloadPath = __DIR__ . '/vendor/autoload.php';

if (file_exists($autoloadPath)) {
    require_once $autoloadPath;
} else {
    spl_autoload_register(static function (string $class): void {
        $prefix = 'Parking\\';
        // str_starts_with() is available in PHP 8+. Use strpos for PHP 7.4 compatibility.
        if (strpos($class, $prefix) !== 0) {
            return;
        }

        $relative = substr($class, strlen($prefix));
        $path = __DIR__ . '/src/' . str_replace('\\', '/', $relative) . '.php';
        if (file_exists($path)) {
            require_once $path;
        }
    });
}

use Parking\Config;
use Parking\Database;

$config = new Config();
$database = new Database($config);

return [
    'config' => $config,
    'database' => $database,
];
