# قائمة الملفات المهمة للرفع إلى الاستضافة

## ✅ يجب رفعها (مهمة جداً)

```
.env                          ← إعدادات الاستضافة (meezmart)
.env.example                  ← نسخة احتياطية للمرجع
.gitignore                    ← تأكد من وجوده
bootstrap.php                 ← ملف التهيئة الأساسي
composer.json                 ← إذا كنت تستخدم composer
migrate.php                   ← سكريبت الترحيلات

src/                          ← جميع ملفات PHP الأساسية
  ├── Auth.php
  ├── Config.php
  ├── Database.php
  ├── Installer.php
  └── ...

public/                       ← جميع الملفات العامة
  ├── index.php
  ├── home.php
  ├── login.php
  ├── install.php
  ├── hosting-diagnostic.php ← للتشخيص (اختياري)
  ├── hosting-fix.php        ← للإصلاح (اختياري)
  └── ...

database/                     ← ملفات الترحيلات
  └── migrations/
      └── *.sql

data/                         ← مجلد البيانات (اجعله قابل للكتابة)
  └── .gitkeep
```

## ❌ لا ترفع (محلي فقط)

```
.env.local                    ← إعدادات التطوير المحلي فقط!
node_modules/                 ← إذا استخدمت npm
vendor/                       ← composer dependencies (اختياري)
.vscode/                      ← إعدادات المحرر الشخصية
.idea/                        ← إعدادات IDE الشخصية
*.log                         ← ملفات السجلات
```

---

## 🔧 خطوات الرفع عبر FTP

### 1. تحضير الملفات محلياً

تأكد أن لديك نسخة، **بدون** `.env.local`:

```bash
# في سطر الأوامر
cd /path/to/parking
ls -la                    # تحقق من وجود .env و .env.local
rm .env.local             # احذفه قبل الرفع
```

### 2. إعدادات FTP

```
Host:          ftp.meezmart.com
Username:      [من لوحة التحكم]
Password:      [من لوحة التحكم]
Port:          21
Remote Path:   /public_html/parking/
```

### 3. رفع الملفات

استخدم FileZilla أو أي عميل FTP:

1. اتصل بـ FTP
2. اسحب المجلدات التالية:
   ```
   src/
   public/
   database/
   data/
   ```
3. رفع الملفات:
   ```
   .env
   .env.example
   .gitignore
   bootstrap.php
   composer.json
   migrate.php
   ...
   ```

### 4. صلاحيات الملفات

بعد الرفع، قد تحتاج لتعديل الصلاحيات عبر File Manager:

```
data/                     → 755 (قابلة للكتابة)
public/                   → 755
src/                      → 755
```

---

## 📋 التحقق بعد الرفع

1. افتح: `https://park.meezmart.com/public/hosting-diagnostic.php`
2. تحقق من:
   - ✅ `.env` موجود
   - ✅ الاتصال بـ MySQL ناجح
   - ✅ قاعدة البيانات `meezma5_parking` موجودة
   - ✅ الجداول موجودة (أو قم بالإصلاح)

3. إذا كانت هناك مشاكل:
   - افتح: `https://park.meezmart.com/public/hosting-fix.php`
   - اتبع التعليمات

---

## 🚨 حل المشاكل الشائعة

### ❌ الخطأ: "Access denied for user 'root'@'localhost'"

**السبب:** بيانات الاتصال خاطئة

**الحل:** تحقق من `.env`:
```dotenv
# هذه البيانات الصحيحة من meezmart:
DB_USER=meezma5_parking
DB_PASSWORD=Ahmedabass0110!
DB_NAME=meezma5_parking
```

### ❌ صفحة التثبيت تظهر في كل مرة

**السبب:** `.env.local` موجود ويغطي الإعدادات

**الحل:**
```bash
# من لوحة التحكم / File Manager
1. احذف ملف .env.local من الاستضافة
2. أو افتح: https://park.meezmart.com/public/hosting-fix.php?action=remove-local
```

### ❌ الخطأ: "Unable to connect to MySQL database"

**السبب:** MySQL معطل أو البيانات خاطئة

**الحل:**
1. سجّل الدخول إلى لوحة التحكم (cPanel)
2. تحقق من MySQL من MySQL Databases
3. أنشئ مستخدماً جديداً إذا لزم الأمر
4. حدّث `.env` بالبيانات الصحيحة

### ❌ الخطأ: "file_put_contents failed"

**السبب:** صلاحيات الملفات غير كافية

**الحل:** عبر File Manager في cPanel:
1. انقر بزر اليمين على `data/`
2. اختر "Change Permissions"
3. اجعلها `755`

