# Parking Concierge System

Valet parking management system built with PHP 7.4, PDO (MySQL or SQLite), and optional Twilio messaging. It covers vehicle check-in, customer notifications, live dashboard, and vehicle return.

## Features

- Installation wizard with requirement checks and automatic database setup
- Vehicle registration, customer portal (request link), and live attendant dashboard
- REST-style endpoints for ticket updates
- MySQL (recommended) or SQLite support with migrations
- Responsive UI with Arabic support

## Requirements

- PHP 7.4+
- Extensions: pdo, and either pdo_mysql (MySQL) or pdo_sqlite/sqlite3/sqlite (SQLite)
- Web server serving the `public/` directory
- Optional Twilio account for SMS/WhatsApp

## Quick start (Windows PowerShell)

1) Copy environment file
- Copy `.env.example` to `.env` and set values, or run the installer (next step).

2) Run installer in browser
- http://localhost:8000/install.php
- The wizard writes `.env`, creates tables, and seeds admin.

3) Start a local server
- From project root: `php -S localhost:8000 -t public`

4) Use the app
- Register a vehicle at `/` and open `/dashboard.php` in another tab.
- Use the customer link to request the vehicle and watch updates live.

## Database and migrations

- MySQL fresh installs use a single unified schema file: `database/migrations/000_full_mysql.sql`.
- A CLI runner is available: `php migrate.php`.
- An admin-only web runner exists at: `/public/admin-migrate.php`.
- SQLite environments skip the MySQL full schema file and use SQLite-friendly statements.

## Environment variables (.env)

Common keys:
- APP_ENV=production
- APP_URL=https://your-domain.com/parking
- DB_DRIVER=mysql (or sqlite)
- For MySQL: DB_HOST, DB_PORT, DB_NAME, DB_USER, DB_PASSWORD, DB_CHARSET=utf8mb4
- For SQLite: DB_PATH=./data/parking.db
- Twilio: TWILIO_ACCOUNT_SID, TWILIO_AUTH_TOKEN, TWILIO_MESSAGING_SERVICE_SID, TWILIO_WHATSAPP_ENABLED=false
- ATTENDANT_PHONE=

## Diagnostics and checks

- Requirements (text): `/public/check-requirements.php`
- Full diagnostics: `/public/diagnostics.php`
- Installer: `/public/install.php`

## Project structure

public/
- index.php, dashboard.php, install.php, diagnostics.php, check-requirements.php
- api/status.php, api/tickets.php

src/
- Database.php, Installer.php, MigrationRunner.php, ParkingRepository.php, Notifier.php

database/
- migrations/000_full_mysql.sql

## Notes

- Default admin is seeded when using MySQL full schema; change the password after first login.
- For production, point the web server document root to `public/`.
- On shared hosting without CLI access, run `/public/admin-migrate.php` after uploading new migrations.

Happy parking 🅿️
